<script type="text/javascript">
    app.controller('table', function($scope){
        $scope.reverse = false;
        $scope.sortField = null;
        $scope.maxSize = 5;
        $scope.itemsPerPage = undefined;
        $scope.bigCurrentPage = 1;
        $scope.bigTotalItems = undefined;
        $scope.post = {};
        $scope.filter = {};
        $scope.data = {};

        $scope.sendPost = function(){};
        $scope.ifReset = function(){};

        $scope.basePost = function(){
            return {
                'sortField' : $scope.sortField,
                'reverse': $scope.reverse
            };
        };

        $scope.updPost = function(){
            $scope.post = $.extend($scope.post, $scope.basePost());
        };

        $scope.getData = function(){
            $scope.updPost();
            $scope.sendPost();
        };

        $scope.showPagination = function(){
            return $scope.bigTotalItems > $scope.itemsPerPage ? true : false;
        };

        /* btn */
        $scope.apply = function(){
            $scope.post = $scope.basePost();
            $scope.post = $.extend($scope.post, $scope.filter);
            $scope.getData();
        };

        $scope.reset = function(){
            $scope.ifReset();
            $scope.post = $scope.basePost();
            $scope.setDefaultValue();

            angular.forEach($scope.filter, function(value,index){
                $scope.filter[index] = null;
            });
        };

        $scope.setDefaultValue = function(){
            $scope.bigTotalItems = undefined;
            $scope.bigCurrentPage = 1;
            $scope.data = {};
        };

        /* sort */
        $scope.sort = function(fieldName){
            if($scope.sortField === fieldName){
                $scope.reverse = !$scope.reverse;
            }else{
                $scope.sortField = fieldName;
                $scope.reverse = false;
            }
            $scope.getData();
        };

        $scope.isSortUp = function(fieldName){
            return $scope.sortField === fieldName && !$scope.reverse;
        };

        $scope.isSortDown = function(fieldName){
            return $scope.sortField === fieldName && $scope.reverse;
        };
    });
</script>